<?php
/*

File: king-include/king-ajax-click-wall.php
Description: Server-side response to Ajax single clicks on wall posts

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

More about this license: LICENCE.html
 */



require_once QA_INCLUDE_DIR . 'king-db/selects.php';
require_once QA_INCLUDE_DIR . 'king-util/string.php';

$result = qa_post_text( 'result' );

if ( $result ) {
	$relatedquestions = qa_db_select_with_pending(
		qa_db_search_posts_selectspec( null, qa_string_to_words( $result ), null, null, null, null, 0, false, 5 )
	);
	$count    = 0;
	$maxcount = 5;
	$out      = '';

	foreach ( $relatedquestions as $question ) {
		$out .= '<a href="' . qa_path_html( qa_q_request( $question['postid'], $question['title'] ), null, qa_opt( 'site_url' ) ) . '">' . qa_html( $question['title'] ) . '</a>';

		if (  ( ++$count ) >= $maxcount ) {
			break;
		}
	}

	echo "QA_AJAX_RESPONSE\n1\n";

	echo $out . "\n";
}
